<?php
session_start();
include 'db.php';
include 'header.php'; // Include the header with the menu

// Check if the user is logged in and is an Admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Fetch total sales and earnings for each product
try {
    $sql = "SELECT p.id AS product_id, p.name AS product_name, 
                   SUM(o.quantity) AS total_quantity, 
                   SUM(o.quantity * p.price) AS total_sales, 
                   COALESCE(SUM(o.quantity * p.price * (d.discount_percentage / 100)), 0) AS total_discount,
                   SUM(o.quantity * p.price) - COALESCE(SUM(o.quantity * p.price * (d.discount_percentage / 100)), 0) AS total_earned
            FROM orders o
            JOIN products p ON o.product_id = p.id
            LEFT JOIN discounts d ON p.id = d.product_id 
            AND d.company_id = (SELECT company_id FROM users WHERE id = o.user_id)
            GROUP BY p.id, p.name";

    $stmt = $pdo->query($sql);
    $sales_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error fetching sales data: " . htmlspecialchars($e->getMessage()) . "</div>";
    exit;
}

// Calculate grand totals
$grand_total_sales = 0;
$grand_total_discount = 0;
$grand_total_earned = 0;

foreach ($sales_data as $data) {
    $grand_total_sales += $data['total_sales'];
    $grand_total_discount += $data['total_discount'];
    $grand_total_earned += $data['total_earned'];
}

function formatCurrency($amount) {
    return number_format($amount, 2);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Total Sales and Earnings</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .print-btn {
            margin: 20px 0;
        }
    </style>
            <link rel="stylesheet" href="./Style/css/Clogin.css">
            <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container">
    <h1 class="mt-4">Total Sales and Earnings</h1>
    <button class="btn btn-primary print-btn" onclick="window.print()">Print</button>
    <table class="table">
        <thead>
            <tr>
                <th>Product ID</th>
                <th>Product Name</th>
                <th>Total Quantity Sold</th>
                <th>Total Sales</th>
                <th>Total Discount</th>
                <th>Total Earnings</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($sales_data as $data): ?>
                <tr>
                    <td><?= htmlspecialchars($data['product_id']) ?></td>
                    <td><?= htmlspecialchars($data['product_name']) ?></td>
                    <td><?= htmlspecialchars($data['total_quantity']) ?></td>
                    <td><?= htmlspecialchars(formatCurrency($data['total_sales'] ?? 0)) ?></td>
                    <td><?= htmlspecialchars(formatCurrency($data['total_discount'] ?? 0)) ?></td>
                    <td><?= htmlspecialchars(formatCurrency($data['total_earned'] ?? 0)) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="3">Grand Total</th>
                <th><?= htmlspecialchars(formatCurrency($grand_total_sales)) ?></th>
                <th><?= htmlspecialchars(formatCurrency($grand_total_discount)) ?></th>
                <th><?= htmlspecialchars(formatCurrency($grand_total_earned)) ?></th>
            </tr>
        </tfoot>
    </table>
</div>
<div class="container"></div>
</body>
</html>
