// Set session configurations before starting the session
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
// Start output buffering to prevent any output before PDF generation
ob_start();

// Start session and include necessary files
session_start();
include 'db.php'; // Make sure your database connection file is included
include 'cheader.php'; 
$user_id = $_SESSION['user_id'];

// Fetch the username from the database
$sql = "SELECT username FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$username = $user['username'];

// Fetch the company ID from the users table
$sql = "SELECT company_id FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $company_id = $user['company_id'];
} else {
    die("User not found.");
}

// Fetch the company logo
$company_sql = "SELECT logo FROM companies WHERE id = ?";
$company_stmt = $pdo->prepare($company_sql);
$company_stmt->execute([$company_id]);
$company = $company_stmt->fetch(PDO::FETCH_ASSOC);

// Set a fallback if the logo is missing
$company_logo = $company ? $company['logo'] : 'default_logo.png'; // Assuming 'default_logo.png' is your fallback logo path

require('./fpdf/fpdf.php');

class PDF extends FPDF {
    public $orderNo;
    public $currentDateTime;
    // Header
    function Header() {
      // Logo
      $this->Image('uploads/logo.jpg', 10, 10, 33); // Adjust path, X, Y, and width
      $this->SetFont('Arial', 'B', 12);
      $this->Cell(80);
      $this->Cell(30, 10, 'Thank You for Shopping from fworder.com', 0, 0, 'C');
      $this->Ln(20); // Line break

      // Company address
      $this->SetFont('Arial', '', 10);
      $this->Cell(0, 10, 'HA DISTRIBUTION LTD Unit 3, 38 Ernest Avenue, LONDON, SE27 0DJ', 0, 1, 'C');
      $this->Ln(10); // Additional spacing
     // Display Order No and Date & Time in one line
     $this->SetFont('Arial', '', 10);
     $this->Cell(0, 10, 'Order No: ' . $this->orderNo, 0, 0, 'L'); // Align left
     $this->Cell(0, 10, 'Date & Time: ' . $this->currentDateTime, 0, 1, 'R'); // Align right
     $this->Ln(10);
    
    }

    // Footer
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');

        // Company address
      $this->SetFont('Arial', '', 10);
      $this->Cell(0, 10, 'HA DISTRIBUTION LTD Unit 3, 38 Ernest Avenue, LONDON, SE27 0DJ', 0, 1, 'C');
      $this->Ln(10); // Additional spacing
    }
}


// Create instance of PDF
$pdf = new PDF();
$pdf->AliasNbPages();

// Check if the session is still valid
$inactive = 1800; // 30 minutes timeout
if (isset($_SESSION['timeout'])) {
    $session_life = time() - $_SESSION['timeout'];
    if ($session_life > $inactive) {
        // Session has expired
        session_destroy();
        header("Location: login.php");
        exit;
    }
}
$_SESSION['timeout'] = time(); // Reset session timeout

// Regenerate session ID after the user successfully logs in
if (!isset($_SESSION['session_regenerated'])) {
    session_regenerate_id(true);
    $_SESSION['session_regenerated'] = true; // Flag to avoid regenerating on every request
}

// Check if the user is logged in and is a client
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 3) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Pagination setup
$limit = 50; // Number of products per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Fetch the company ID
$sql = "SELECT company_id FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$company = $stmt->fetch(PDO::FETCH_ASSOC);
$company_id = $company['company_id'];

// Fetch all products with their discount details
$products = []; // Initialize the products variable
$sql = "SELECT p.*, 
               COALESCE(d.discount_percentage, 0) AS discount_percentage,
               COALESCE(d.discount_amount, 0) AS discount_amount
        FROM products p
        LEFT JOIN discounts d ON p.id = d.product_id AND d.company_id = ?
        LIMIT ? OFFSET ?";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(1, $company_id, PDO::PARAM_INT);
$stmt->bindValue(2, (int) $limit, PDO::PARAM_INT);
$stmt->bindValue(3, (int) $offset, PDO::PARAM_INT);

if ($stmt->execute()) {
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    // Handle the error (you can log this error for debugging)
    $notification .= "<div class='alert alert-danger'>Failed to fetch products. Please try again later.</div>";
}

// Get total product count for pagination
$sql = "SELECT COUNT(*) AS total FROM products";
$totalProductsStmt = $pdo->prepare($sql);
$totalProductsStmt->execute();
$totalProducts = $totalProductsStmt->fetch(PDO::FETCH_ASSOC)['total'];
$totalPages = ceil($totalProducts / $limit);

// Handle placing orders and generating PDF
$notification = '';
$pdfOutput = false; // Flag to check if we need to generate PDF

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['place_order'])) {
    $product_quantities = $_POST['product_quantities'];
    $orderDetails = []; // Array to hold order details for the PDF

    foreach ($product_quantities as $product_id => $quantities) {
        // Retrieve the box and single quantities
        $single_quantity = (int) $quantities['single'];
        $box_quantity = (int) $quantities['box'];

        // Calculate total quantity (single or box)
        $total_quantity = $single_quantity + ($box_quantity * 12); // Assuming 12 items per box

        if ($total_quantity <= 0) {
            continue; // Skip if no quantity is selected
        }

        // Fetch product details and calculate the discounted price
        $sql = "SELECT price, name FROM products WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$product_id]);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);
        $price = $product['price'];
        $product_name = $product['name'];

        $discounted_price = $price; // Initialize the discounted price

        // Fetch discount details
        $sql = "SELECT discount_percentage, discount_amount FROM discounts WHERE product_id = ? AND company_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$product_id, $company_id]);
        $discount = $stmt->fetch(PDO::FETCH_ASSOC);

        // Apply discount if available
        if ($discount) {
            if ($discount['discount_amount'] > 0) {
                $discounted_price -= $discount['discount_amount'];
            } elseif ($discount['discount_percentage'] > 0) {
                $discounted_price -= ($price * ($discount['discount_percentage'] / 100));
            }
        }

        // Calculate total amount
        $total_amount = $discounted_price * $total_quantity;

        // Save the order in the database
        $sql = "INSERT INTO orders (user_id, product_id, quantity, total_amount, status, item_type, box_quantity) VALUES (?, ?, ?, ?, 'pending', ?, ?)";
        $stmt = $pdo->prepare($sql);
        if ($stmt->execute([$user_id, $product_id, $total_quantity, $total_amount, $box_quantity > 0 ? 'box' : 'single', $box_quantity])) {
            $notification .= "<div class='alert alert-success'>Order for Product ID $product_id placed successfully. Price: £.$total_amount.</div>";
            $orderDetails[] = [
                'name' => $product_name,
                'quantity' => $total_quantity,
                'price' => $total_amount,
            ];
            $pdfOutput = true; // Set flag to generate PDF
        } else {
            $notification .= "<div class='alert alert-danger'>Failed to place order for Product ID $product_id. Please try again.</div>";
        }
    }

    // Generate PDF if orders were placed successfully
    if ($pdfOutput) {
        ob_end_clean(); // Clean output buffer before PDF generation
        $grandTotalAmount = 0; // Initialize grand total amount

        // Create instance of PDF
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(40, 10, 'Order Details', 0, 1);

        // Add order details table header
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(40, 10, 'Product Image', 1);
        $pdf->Cell(80, 10, 'Product Name', 1);
        $pdf->Cell(40, 10, 'Quantity', 1);
        $pdf->Cell(25, 10, 'Total Price', 1);
        $pdf->Ln(); // Line break

        // Add order details to PDF
        $pdf->SetFont('Arial', '', 12);
        foreach ($orderDetails as $order) {
            // Fetch the image path for the product
            $sql = "SELECT image FROM products WHERE name = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$order['name']]);
            $productImage = $stmt->fetchColumn(); // Fetch the image path

            // Add the image to the PDF (adjust the width and height as needed)
            $pdf->Cell(40, 10, $pdf->Image($productImage, $pdf->GetX() + 1, $pdf->GetY() + 1, 10), 1);

            $pdf->Cell(80, 10, $order['name'], 1);
            $pdf->Cell(40, 10, $order['quantity'], 1);
            $pdf->Cell(25, 10, '£.' . $order['price'], 1);
            $pdf->Ln(); // Line break
            $grandTotalAmount += $order['price']; // Calculate grand total amount
        }

        // Display grand total amount
        $pdf->Cell(40, 10, '', 0);
        $pdf->Cell(80, 10, '', 0);
        $pdf->Cell(40, 10, 'Grand Total:', 1);
        $pdf->Cell(25, 10, '£.' . $grandTotalAmount, 1);
        $pdf->Ln(20);

        // Output the PDF
        $pdf->Output('I', 'order_details.pdf'); // Inline PDF view

        exit; // Prevent further output
    }
}

<script>
        function updateGrandTotal() {
            let grandTotal = 0;

            // Get all the rows in the product table
            const rows = document.querySelectorAll('tbody tr');

            rows.forEach(row => {
                // Check if the checkbox is selected
                const checkbox = row.querySelector('input[type="checkbox"]');
                if (checkbox.checked) {
                    const price = parseFloat(row.cells[3].textContent.replace('£.', '').trim()); // Get the price
                    const singleQuantity = parseInt(row.querySelector('input[name$="[single]"]').value) || 0; // Get single quantity
                    const boxQuantity = parseInt(row.querySelector('input[name$="[box]"]').value) || 0; // Get box quantity

                    // Calculate total for this row (assuming 12 items per box)
                    const totalQuantity = singleQuantity + (boxQuantity * 12);
                    const totalPrice = totalQuantity * price;

                    grandTotal += totalPrice; // Update the grand total
                }
            });

            // Display the grand total
            document.getElementById('grandTotal').textContent = `Grand Total: £.${grandTotal.toFixed(2)}`;
        }

        // Attach event listeners to the quantity inputs and checkboxes
        document.addEventListener('DOMContentLoaded', function () {
            const quantityInputs = document.querySelectorAll('input[type="number"]');
            const checkboxes = document.querySelectorAll('input[type="checkbox"]');

            quantityInputs.forEach(input => {
                input.addEventListener('input', updateGrandTotal);
            });

            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', updateGrandTotal);
            });
        });
    </script>