<?php
// Start session and include necessary files
session_start();
include 'db.php';
include 'header.php';

// Ensure the user is logged in and is an Administrator
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Fetch companies from the database
try {
    $sql = "SELECT * FROM companies";
    $stmt = $pdo->query($sql);
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error fetching companies: " . $e->getMessage();
    $companies = []; // Ensure companies is at least an empty array
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Companies Discounts</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="./style/css/clogin.css">
    <style>
        
body {
    background-color: #0e5091 !important;
}
.container {
    margin-top: 50px;
}
.pagination {
    margin-top: 20px;
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
body {
    background-color: #f8f9fa;
    font-family: Arial, sans-serif;
}
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
.table th, .table td {
    vertical-align: middle;
}
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    position:relative;  
    width: 50%;
}
.btn-primary {
    background-color: #007bff;
    border: none;
}
.btn-primary:hover {
    background-color: #0056b3;
}
.alert {
    margin-top: 20px;
}
.pagination {
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
label {
    font-weight: bold;
    position: absolute;

}
.container h1{
    color: black;
    font-size: x-large;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;
}
.container td, th, tr, label{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
.form-group{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
    </style>
</head>
<body>
<div class="container">
    <h1 class="mt-4">Companies Discounts</h1>
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Discounts</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($companies)): ?>
                <?php foreach ($companies as $company): ?>
                    <tr>
                        <td><?= htmlspecialchars($company['id']) ?></td>
                        <td><?= htmlspecialchars($company['name']) ?></td>
                        <td>
                            <?php
                            // Fetch discounts for this company
                            $sql = "SELECT * FROM discounts WHERE company_id = ?";
                            $stmt = $pdo->prepare($sql);
                            $stmt->execute([$company['id']]);
                            $discounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($discounts as $discount) {
                                echo "Product ID: " . htmlspecialchars($discount['product_id']) . " - " . htmlspecialchars($discount['discount_value']) . " Rs / %<br>";
                            }
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="3">No companies found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<div class="container"></div>
</body>
</html>
