<?php
// Set session configurations before starting the session
ini_set('session.cookie_secure', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

// Start the session
session_start();

// Regenerate session ID to prevent session fixation attacks
session_regenerate_id(true);

// Include database
include 'db.php';

// Check if the user is logged in and is an Administrator
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: dashboard.php');
    exit;
}

// Generate CSRF token if not set
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container">
    <h1 class="mt-4">Admin Panel</h1>
    <p>Manage users, companies, and system settings.</p>
    <!-- Admin management links here -->
    <a href="manage_users.php" class="btn btn-primary">Manage Users</a>
    <a href="manage_companies.php" class="btn btn-primary">Manage Companies</a>
    <a href="settings.php" class="btn btn-primary">System Settings</a>
</div>
</body>
</html>
