<?php
// Start output buffering
ob_start();

// Set session configurations before starting the session
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

// Start session and include necessary files
session_start();
include 'db.php'; // Make sure your database connection file is included
include 'cheader.php';

// Error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if the user is logged in and is a client
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 3) {
    header('Location: login.php');
    exit;
}

// Safely assign user_id since we checked for its existence
$user_id = $_SESSION['user_id'];

// Fetch the username from the database
$sql = "SELECT username FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Check if the user was found
if (!$user) {
    die("User not found.");
}

$username = $user['username'];

// Fetch the company ID from the users table
$sql = "SELECT company_id FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $company_id = $user['company_id'];
} else {
    die("User not found.");
}

// Pagination setup
$limit = 10; // Number of orders per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Fetch all orders for the user with pagination
$sql = "SELECT * FROM orders WHERE user_id = ? ORDER BY order_date DESC LIMIT ? OFFSET ?";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(1, $user_id, PDO::PARAM_INT); // Using user_id to filter
$stmt->bindValue(2, (int)$limit, PDO::PARAM_INT);
$stmt->bindValue(3, (int)$offset, PDO::PARAM_INT);
$stmt->execute();
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get total order count for pagination
$sql = "SELECT COUNT(*) AS total FROM orders WHERE user_id = ?";
$totalOrdersStmt = $pdo->prepare($sql);
$totalOrdersStmt->execute([$user_id]);
$totalOrders = $totalOrdersStmt->fetch(PDO::FETCH_ASSOC)['total'];
$totalPages = ceil($totalOrders / $limit);

// Fetch the company logo
$company_sql = "SELECT logo FROM companies WHERE id = ?";
$company_stmt = $pdo->prepare($company_sql);
$company_stmt->execute([$company_id]);
$company = $company_stmt->fetch(PDO::FETCH_ASSOC);

// Set a fallback if the logo is missing
$company_logo = $company ? $company['logo'] : 'default_logo.png'; // Assuming 'default_logo.png' is your fallback logo path
// Define VAT rate
$vatRate = 0.20; // 20%
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Orders</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="Style/css/cd/cd.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            margin-top: 50px;
            max-width: 800px;
        }
        .order-header {
            cursor: pointer;
        }
        .collapse {
            margin: 10px 0;
        }
    </style>
    <style>
/* General Body Styling */
body {
    background-color: #0e5091 !important;
    font-family: Arial, sans-serif;
    background-color: #f8f9fa;
    margin: 0;
    padding: 0;
}

/* Container Styling */
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    width: 100%;
}

/* Responsive Layouts */
@media (max-width: 768px) {
    .container {
        margin-top: 30px;
        padding: 15px;
    }
    
    .form-control {
        width: 100%;
    }
}

/* Header Styling */
h2 {
    text-align: center;
    margin-bottom: 20px;
    font-size: 1.5em;
}

/* Table Styling */
.table th, .table td {
    vertical-align: middle;
    padding: 10px;
    text-align: left;
}

/* Form Control Styling */
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    width: 50%;
}

@media (max-width: 576px) {
    .form-control {
        width: 100%;
    }
}

/* Button Styling */
.btn-primary {
    background-color: #007bff;
    border: none;
}

.btn-primary:hover {
    background-color: #0056b3;
}

/* Alert Styling */
.alert {
    margin-top: 20px;
}

/* Pagination Styling */
.pagination {
    margin-top: 20px;
    justify-content: center;
}

.disabled {
    pointer-events: none;
    cursor: default;
}

/* Label Styling */
label {
    font-weight: bold;
    display: block;
    margin-bottom: 5px;
}

/* Shadow Effect for Container */
@media (min-width: 992px) {
    .container {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
}

</style>
</head>
<body>
<div class="container" >
<div class="container" >
            <div class="row">
                <div class="col-md-3 col-3"><img src="uploads\logo.jpg" style="width:100%;"></div>
                <div class="col-md-9 col-9">
                    <h1 style="font-size: 1rem !important; text-align: center; font-weight:bolder;">HA Da LTD<br />
                    123, XYZ Street<br />
</h1><br/>
<h1 class="text-center" style="font-size: 1.5rem !important;  font-weight:bolder;">Order History</h1>
        <h4 class="text-right" style="font-size: 1rem !important;   font-weight:bolder; position: absolute;right: 124px;   top: -61px;">Welcome Mr. <?= htmlspecialchars($username) ?></h4>
        <a href="logout.php" class="btn btn-outline-danger" style="    position: absolute;    right: 10px;    top: -70px;">Logout</a><br/></br>
       <!-- <?= $notification ?>  Display notification messages -->
</div></div></div>
    <br/>
        
        <?php if (!empty($orders)): ?>
            <?php foreach ($orders as $order): ?>
                <div class="card">
                    <div class="card-header order-header" data-toggle="collapse" data-target="#order<?= htmlspecialchars($order['order_id'] ?? '') ?>" aria-expanded="false" aria-controls="order<?= htmlspecialchars($order['order_id'] ?? '') ?>">
                        <h5 class="mb-0" style="color:black;">
                            Order ID: <?= htmlspecialchars($order['id'] ?? '') ?> | Date: <?= htmlspecialchars($order['created_at'] ?? 'N/A') ?> | Status: <?= htmlspecialchars($order['status'] ?? 'N/A') ?>
                        </h5>
                    </div>
                    <div id="order<?= htmlspecialchars($order['order_id'] ?? '') ?>" class="collapse">
                    <div class="card-body" style="color:black;">
    <p><strong style="color:black;">Total Amount:</strong> £<?= htmlspecialchars($order['total_amount'] ?? 'N/A') ?></p>
    <p><strong style="color:black;">VAT (20%):</strong> £<?= number_format((float)($order['total_amount'] * $vatRate), 2, '.', '') ?></p>
    <p><strong style="color:black;">Total Amount with VAT:</strong> £<?= number_format((float)($order['total_amount'] * (1 + $vatRate)), 2, '.', '') ?></p>
    <p><strong style="color:black;">Item Type:</strong> <?= htmlspecialchars($order['item_type'] ?? 'N/A') ?></p>
    <p><strong style="color:black;">Quantity:</strong> <?= htmlspecialchars($order['quantity'] ?? 'N/A') ?></p>
    <p><strong style="color:black;">Box Quantity:</strong> <?= htmlspecialchars($order['box_quantity'] ?? 'N/A') ?></p>
</div>

                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-info text-center">No orders available.</div>
        <?php endif; ?>

        <!-- Pagination -->
        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page - 1 ?>">Previous</a>
                </li>
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
                <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page + 1 ?>">Next</a>
                </li>
            </ul>
        </nav>
    </div>
<div class="container"></div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

<?php
// Flush the output buffer
ob_end_flush();
