<?php
// Set session configurations before starting the session
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
// Start output buffering to prevent any output before PDF generation
ob_start();

// Start session and include necessary files
session_start();
include 'db.php';
include 'cheader.php';
$user_id = $_SESSION['user_id'];
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Fetch order number from the database
$orderId = 1; // Replace with the actual order ID you want to retrieve
$stmt = $pdo->prepare("SELECT user_id FROM orders WHERE id = :orderId");
$stmt->execute(['orderId' => $orderId]);

// Fetch the result
$order = $stmt->fetch(PDO::FETCH_ASSOC);
$orderNo = $order ? $order['user_id'] : 'N/A'; // Default to 'nnn' if not found


// Fetch the username from the database
$sql = "SELECT username FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$username = $user['username'];

// Fetch the company ID from the users table
$sql = "SELECT company_id FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $company_id = $user['company_id'];
} else {
    die("User not found.");
}

// Fetch the company logo
$company_sql = "SELECT logo FROM companies WHERE id = ?";
$company_stmt = $pdo->prepare($company_sql);
$company_stmt->execute([$company_id]);
$company = $company_stmt->fetch(PDO::FETCH_ASSOC);

$company_logo = $company ? $company['logo'] : 'default_logo.png';

require('./fpdf/fpdf.php');

class PDF extends FPDF {
    public $orderNo;
    public $currentDateTime;
    public $username;

    function Header() {
      $this->Image('uploads/logo.jpg', 10, 10, 33);
      $this->SetFont('Arial', 'B', 12);
      $this->Cell(80);
      $this->Cell(30, 10, 'Thank You for Shopping from fworder.com', 0, 0, 'C');
      $this->Ln(20);
      $this->SetFont('Arial', '', 10);
      $this->Cell(0, 10, 'mmmmmm', 0, 1, 'C');
      $this->Ln(10);
      $this->SetFont('Arial', '', 10);
      $this->Cell(0, 10, 'Order No: ' . $this->orderNo, 0, 0, 'L');
      $this->Cell(0, 10, 'Date & Time: ' . $this->currentDateTime, 0, 1, 'R');
      $this->Ln(5);
      $this->Cell(0, 10, 'Customer name: ' . $this->username, 0, 1, 'L'); // Display username
      $this->Ln(10);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 10, 'mmmm', 0, 1, 'C');
        $this->Ln(10);
    }
}

// Create instance of PDF
$pdf = new PDF();

// Set the order number and current date/time
$pdf->orderNo = $orderNo;// Replace with your actual order number
$pdf->currentDateTime = date('Y-m-d'); // Current date and time
$pdf->username = $username; // Set the username


$pdf->AliasNbPages();

// Check if the session is still valid
$inactive = 1800;
if (isset($_SESSION['timeout'])) {
    $session_life = time() - $_SESSION['timeout'];
    if ($session_life > $inactive) {
        session_destroy();
        header("Location: login.php");
        exit;
    }
}
$_SESSION['timeout'] = time();
if (!isset($_SESSION['session_regenerated'])) {
    session_regenerate_id(true);
    $_SESSION['session_regenerated'] = true;
}
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 3) {
    header('Location: login.php');
    exit;
}

$vat_rate = 0.2; // VAT rate, e.g., 20%
$limit = 50;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;
// Set a default value to avoid undefined variable warnings
$grandTotalAmount = 0;
$vatAmount = 0;
$totalWithVat = 0;


// Check if grandTotalAmount has been calculated somewhere in your code
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['place_order'])) {
    // Assume $grandTotalAmount was calculated based on the order details
    $vat_rate = 0.2;
    $grandTotalAmount = 100; // Replace this with your actual calculation
    $vatAmount = $grandTotalAmount * $vat_rate;
    $totalWithVat = $grandTotalAmount + $vatAmount;
}
// Fetch the company ID
$sql = "SELECT company_id FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$company = $stmt->fetch(PDO::FETCH_ASSOC);
$company_id = $company['company_id'];

$products = [];
$sql = "SELECT p.*, COALESCE(d.discount_percentage, 0) AS discount_percentage, COALESCE(d.discount_amount, 0) AS discount_amount
        FROM products p
        LEFT JOIN discounts d ON p.id = d.product_id AND d.company_id = ?
        LIMIT ? OFFSET ?";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(1, $company_id, PDO::PARAM_INT);
$stmt->bindValue(2, (int) $limit, PDO::PARAM_INT);
$stmt->bindValue(3, (int) $offset, PDO::PARAM_INT);

if ($stmt->execute()) {
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$sql = "SELECT COUNT(*) AS total FROM products";
$totalProductsStmt = $pdo->prepare($sql);
$totalProductsStmt->execute();
$totalProducts = $totalProductsStmt->fetch(PDO::FETCH_ASSOC)['total'];
$totalPages = ceil($totalProducts / $limit);

$notification = '';
$pdfOutput = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['place_order'])) {
    $product_quantities = $_POST['product_quantities'];
    $orderDetails = [];
    $grandTotalAmount = 0;

    foreach ($product_quantities as $product_id => $quantities) {
        $single_quantity = (int) $quantities['single'];
        $box_quantity = (int) $quantities['box'];
        $total_quantity = $single_quantity + ($box_quantity * 12);

        if ($total_quantity <= 0) {
            continue;
        }

        $sql = "SELECT price, name FROM products WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$product_id]);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);
        $price = $product['price'];
        $product_name = $product['name'];
        $discounted_price = $price;

        $sql = "SELECT discount_percentage, discount_amount FROM discounts WHERE product_id = ? AND company_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$product_id, $company_id]);
        $discount = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($discount) {
            if ($discount['discount_amount'] > 0) {
                $discounted_price -= $discount['discount_amount'];
            } elseif ($discount['discount_percentage'] > 0) {
                $discounted_price -= ($price * ($discount['discount_percentage'] / 100));
            }
        }

        $total_amount = $discounted_price * $total_quantity;
        $sql = "INSERT INTO orders (user_id, product_id, quantity, total_amount, status, item_type, box_quantity) VALUES (?, ?, ?, ?, 'pending', ?, ?)";
        $stmt = $pdo->prepare($sql);
        if ($stmt->execute([$user_id, $product_id, $total_quantity, $total_amount, $box_quantity > 0 ? 'box' : 'single', $box_quantity])) {
            $notification .= "<div class='alert alert-success'>Order for Product ID $product_id placed successfully. Price: £.$total_amount.</div>";
            $orderDetails[] = [
                'name' => $product_name,
                'quantity' => $total_quantity,
                'price' => $total_amount,
            ];
            $pdfOutput = true;
            $grandTotalAmount += $total_amount;
        } else {
            $notification .= "<div class='alert alert-danger'>Failed to place order for Product ID $product_id. Please try again.</div>";
        }
    }

    if ($pdfOutput) {
        ob_end_clean();
        $vatAmount = $grandTotalAmount * $vat_rate;
        $totalWithVat = $grandTotalAmount + $vatAmount;

        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(40, 10, 'Order Details', 0, 1);
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(40, 10, 'Product Image', 1);
        $pdf->Cell(80, 10, 'Product Name', 1);
        $pdf->Cell(40, 10, 'Quantity', 1);
        $pdf->Cell(25, 10, 'Total Price', 1);
        $pdf->Ln();

        $pdf->SetFont('Arial', '', 12);
        foreach ($orderDetails as $order) {
            $sql = "SELECT image FROM products WHERE name = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$order['name']]);
            $productImage = $stmt->fetchColumn();

            $pdf->Cell(40, 40, $pdf->Image($productImage, $pdf->GetX(), $pdf->GetY(), 30), 1);
            $pdf->Cell(80, 40, $order['name'], 1);
            $pdf->Cell(40, 40, $order['quantity'], 1);
            $pdf->Cell(25, 40, '£.' . number_format($order['price'], 2), 1);
            $pdf->Ln();
        }

        $pdf->Cell(40, 10, '', 0);
        $pdf->Cell(80, 10, '', 0);
        $pdf->Cell(40, 10, 'Grand Total:', 1);
        $pdf->Cell(25, 10, '£.' . number_format($grandTotalAmount, 2), 1);
        $pdf->Ln();

        $pdf->Cell(40, 10, '', 0);
        $pdf->Cell(80, 10, '', 0);
        $pdf->Cell(40, 10, 'VAT (20%):', 1);
        $pdf->Cell(25, 10, '£.' . number_format($vatAmount, 2), 1);
        $pdf->Ln();

        $pdf->Cell(40, 10, '', 0);
        $pdf->Cell(80, 10, '', 0);
        $pdf->Cell(40, 10, 'Total with VAT:', 1);
        $pdf->Cell(25, 10, '£.' . number_format($totalWithVat, 2), 1);
        $pdf->Ln(20);

        $pdf->Output();
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Place Orders</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<style>
/* General Body Styling */
body {
    background-color: #0e5091 !important;
    font-family: Arial, sans-serif;
    background-color: #f8f9fa;
    margin: 0;
    padding: 0;
}

/* Container Styling */
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    width: 100%;
}

/* Responsive Layouts for Standard Smaller Screens */
@media (max-width: 768px) {
    .container {
        margin-top: 30px;
        padding: 15px;
    }
    
    .form-control {
        width: 100%;
    }
}

/* Specific Styling for 414px Width Screens */
@media (max-width: 414px) {
   
    .container {
        margin-top: 20px;
        padding: 10px;
    }
    .mobileT{
        display:none;
    }
    h1{
        style="font-size: 1rem !important;
    text-align: center; font-weight:bolder;"
    }
    h2 {
        font-size: 0.3em;
    }

    /* Table Container: Allows Scroll for Small Screen */
    .table-container {
        overflow-x: auto;
        width: 100%;
    }
    
    .table th, .table td {
        padding: 8px;
        font-size: 0.9em;
    }
    
    /* Form Control Full Width */
    .form-control {
        width: 100%;
    }

    /* Button Styling for Smaller Screens */
    .btn-primary {
        font-size: 0.9em;
        padding: 8px 12px;
    }
    
    /* Adjust Pagination */
    .pagination {
        font-size: 0.9em;
        padding: 8px;
    }
}

/* Header Styling */
h2 {
    text-align: center;
    margin-bottom: 20px;
    font-size: 1.5em;
}

/* Table Styling */
.table-container {
    overflow-x: auto;
    width: 100%;
}
.table {
    width: 100%;
    border-collapse: collapse;
}
.table th, .table td {
    vertical-align: middle;
    padding: 5px;
    text-align: left;
    border: 1px solid #dee2e6;
}

/* Form Control Styling */
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    width: 50%;
}

/* Additional General Responsive Styling */
@media (max-width: 576px) {
    .cm{
        display:none;
    }
    .form-control {
        width: 100%;
    }
}

/* Button Styling */
.btn-primary {
    background-color: #007bff;
    border: none;
}

.btn-primary:hover {
    background-color: #0056b3;
}

/* Alert Styling */
.alert {
    margin-top: 20px;
}

/* Pagination Styling */
.pagination {
    margin-top: 20px;
    justify-content: center;
}

.disabled {
    pointer-events: none;
    cursor: default;
}

/* Label Styling */
label {
    font-weight: bold;
    display: block;
    margin-bottom: 5px;
}

/* Shadow Effect for Larger Screens */
@media (min-width: 992px) {
    .container {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
}

</style>

<script>
    function updateGrandTotal() {
        let grandTotal = 0;

        // Get all the rows in the product table
        const rows = document.querySelectorAll('tbody tr');

        rows.forEach(row => {
            // Check if the checkbox is selected
            const checkbox = row.querySelector('input[type="checkbox"]');
            if (checkbox.checked) {
                const price = parseFloat(row.cells[3].textContent.replace('£.', '').trim()); // Get the price
                const singleQuantity = parseInt(row.querySelector('input[name$="[single]"]').value) || 0; // Get single quantity
                const boxQuantity = parseInt(row.querySelector('input[name$="[box]"]').value) || 0; // Get box quantity

                // Calculate total for this row (assuming 12 items per box)
                const totalQuantity = singleQuantity + (boxQuantity * 12);
                const totalPrice = totalQuantity * price;

                grandTotal += totalPrice; // Update the grand total
            }
        });

        // Calculate VAT (20%)
        const vatRate = 0.20;
        const vatAmount = grandTotal * vatRate;
        const totalWithVat = grandTotal + vatAmount;

        // Display the grand total, VAT, and total with VAT
        document.getElementById('grandTotal').textContent = `Grand Total: £${grandTotal.toFixed(2)}`;
        document.getElementById('vatAmount').textContent = `VAT (20%): £${vatAmount.toFixed(2)}`;
        document.getElementById('totalWithVat').textContent = `Total Including VAT: £${totalWithVat.toFixed(2)}`;
    }

    // Attach event listeners to the quantity inputs and checkboxes
    document.addEventListener('DOMContentLoaded', function () {
        const quantityInputs = document.querySelectorAll('input[type="number"]');
        const checkboxes = document.querySelectorAll('input[type="checkbox"]');

        quantityInputs.forEach(input => {
            input.addEventListener('input', updateGrandTotal);
        });

        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', updateGrandTotal);
        });
    });
</script>

</head>
<body>
    <div class="container">
        <div class="container" >
            <div class="row">
                <div class="col-md-3 col-3"><img src="uploads\logo.jpg" style="width:100%;"></div>
                <div class="col-md-9 col-9">
                <h1 style="font-size: 1rem !important; text-align: center; font-weight:bolder;">HA Da LTD<br />
                123, XYZ Street<br />
</h1><br/>
<h1 class="text-center" style="font-size: 1.5rem !important;  font-weight:bolder;">Order Form</h1>
        <h4 class="text-right" style="font-size: 1rem !important;   font-weight:bolder; position: absolute;right: 124px;   top: -61px;">Welcome Mr. <?= htmlspecialchars($username) ?></h4>
        <a href="logout.php" class="btn btn-outline-danger" style="    position: absolute;    right: 10px;    top: -70px;">Logout</a><br/></br>
        <?= $notification ?> <!-- Display notification messages -->
</div></div></div>
<div class="container">
<div class="row">
<div class="col-md-3 col-3">
    <!-- <?php echo '<img src="' . ($company_logo !== null ? htmlspecialchars($company_logo) : '') . '" alt="Company Logo" style="max-width: 100%;">'; ?>  -->
</div>

    <br/>
        <form method="POST">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th class="mobileT">Select</th>
                        <th>Image</th>
                        <th>Product Name</th>
                        <th>Price</th>
                        <th>Pcs</th>
                        <th>Box</th>

                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($products)): ?>
                        <?php foreach ($products as $product): ?>
                            <tr>
                                <td class="mobileT"><input type="checkbox" name="product_quantities[<?= $product['id'] ?>][select]" value="1"></td>
                                <td><img src="<?= htmlspecialchars($product['image']) ?>" alt="<?= htmlspecialchars($product['name']) ?>" width="50"></td>
                                <td><?= htmlspecialchars($product['name']) ?></td>
                                <td>£.<?= htmlspecialchars($product['price']) ?></td>
                                <td>
                                    <input type="number" name="product_quantities[<?= $product['id'] ?>][single]" min="0" max="99" placeholder="Single" value="0">
                                </td>
                                <td>
                                <input type="number" name="product_quantities[<?= $product['id'] ?>][box]" min="0" max="99" placeholder="Box" value="0">

                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">No products available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

<div>
    <!-- Display of Grand Total, VAT, and Total with VAT -->
    <div class="alert alert-info mobileT" id="grandTotal">
    Grand Total: £0.00
</div>
    <div class="alert alert-info mobileT" id="vatAmount">
    VAT (20%): £0.00
</div>
<div class="alert alert-info mobileT" id="totalWithVat">
    Total Including VAT: £0.00
</div>



</div>

            <button type="submit" name="place_order" class="btn btn-primary">Place Orders</button>
        </form>
                <!-- Pagination -->
                <nav>
            <ul class="pagination">
                <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page - 1 ?>">Previous</a>
                </li>
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
                <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page + 1 ?>">Next</a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="container"></div>
</body>
</html>
