<?php
session_start();

// Include necessary files
include 'db.php';
include 'header.php';

// Ensure the client is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Fetch products with discounts for the client
$company_id = $_SESSION['company_id']; // Assuming company_id is stored in session
$sql = "SELECT p.id, p.name, p.price, d.discount_type, d.discount_value
        FROM products p
        LEFT JOIN discounts d ON p.id = d.product_id AND d.company_id = :company_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['company_id' => $company_id]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Client Request</title>
    <link rel="stylesheet" type="text/css" href="styles.css"> <!-- Link to your CSS -->
    <link rel="stylesheet" href="./Style/css/Clogin.css">
    <style>
    
body {
    background-color: #0e5091 !important;
}
.container {
    margin-top: 50px;
}
.pagination {
    margin-top: 20px;
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
body {
    background-color: #f8f9fa;
    font-family: Arial, sans-serif;
}
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
.table th, .table td {
    vertical-align: middle;
}
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    position:relative;  
    width: 50%;
}
.btn-primary {
    background-color: #007bff;
    border: none;
}
.btn-primary:hover {
    background-color: #0056b3;
}
.alert {
    margin-top: 20px;
}
.pagination {
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
label {
    font-weight: bold;
    position: absolute;

}
.container h1{
    color: black;
    font-size: x-large;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;
}
.container td, th, tr, label{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
.form-group{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
lable{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
</style>
    </head>
<body>
    <div class="container">
        <h1>Order Form</h1>

        <form action="submit_order.php" method="post">
            <table border="1" class="table">
                <thead>
                    <tr>
                        <th>Product Name</th>
                        <th>Original Price</th>
                        <th>Discount</th>
                        <th>Discounted Price</th>
                        <th>Quantity</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $product): ?>
                        <?php
                        // Calculate discounted price
                        $original_price = $product['price'];
                        $discounted_price = $original_price;

                        if ($product['discount_type'] && $product['discount_value']) {
                            if ($product['discount_type'] == 'percentage') {
                                $discounted_price = $original_price * (1 - $product['discount_value'] / 100);
                            } elseif ($product['discount_type'] == 'amount') {
                                $discounted_price = $original_price - $product['discount_value'];
                            }
                        }
                        ?>
                        <tr>
                            <td><?php echo htmlspecialchars($product['name']); ?></td>
                            <td><?php echo number_format($original_price, 2); ?> Rs</td>
                            <td>
                                <?php if ($product['discount_type'] && $product['discount_value']): ?>
                                    <?php echo htmlspecialchars($product['discount_value']); ?>
                                    <?php echo ($product['discount_type'] == 'percentage') ? '%' : 'Rs'; ?>
                                <?php else: ?>
                                    None
                                <?php endif; ?>
                            </td>
                            <td><?php echo number_format($discounted_price, 2); ?> Rs</td>
                            <td>
                                <input type="number" name="quantity[<?php echo $product['id']; ?>]" min="0" step="1" value="0">
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <br>
            <button type="submit">Submit Order</button>
        </form>
    </div>
    <div class="container"></div>
</body>
</html>
