<?php
session_start();
include 'db.php';

// Check if the user is logged in and is an Administrator
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Handle delete request
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];

    // Delete the discount from the database
    $delete_sql = "DELETE FROM discounts WHERE id = :id";
    $delete_stmt = $pdo->prepare($delete_sql);
    $delete_stmt->execute([':id' => $id]);

    header('Location: manage_discounts.php');
    exit;
} else {
    die('Invalid request.');
}
