<?php
include 'db.php';

// Check if 'id' is present in the URL and is a valid integer
if (isset($_GET['id']) && filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $id = $_GET['id'];
    
    // Prepare and execute the deletion query
    $sql = "DELETE FROM products WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$id])) {
        // Optionally, you can add a success message here
        // For example, set a session flash message to inform the user
    } else {
        // Handle the case where deletion fails
        // Redirect or show an error message
    }
} else {
    // Redirect or show an error message if 'id' is invalid
}

// Redirect to the index page
header('Location: index.php');
exit; // It's good practice to call exit after header redirection
?>
