<?php
session_start();
include 'db.php';
include 'header.php';

// Check if the user is logged in and is an Administrator
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Fetch the discount to be edited
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $sql = "SELECT d.*, c.name AS company_name, p.name AS product_name 
            FROM discounts d 
            JOIN companies c ON d.company_id = c.id 
            JOIN products p ON d.product_id = p.id 
            WHERE d.id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $id]);
    $discount = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$discount) {
        die('Discount not found.');
    }
} else {
    die('Invalid request.');
}

// Handle form submission for editing
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_id = $_POST['company_id'];
    $product_id = $_POST['product_id'];
    $discount_value = $_POST['discount_value'];
    $discount_type = $_POST['discount_type'];
    $quantity = $_POST['quantity'];

    // Update the discount in the database
    $update_sql = "UPDATE discounts 
                   SET company_id = :company_id, product_id = :product_id, discount_value = :discount_value, 
                       discount_type = :discount_type, quantity = :quantity 
                   WHERE id = :id";
    $update_stmt = $pdo->prepare($update_sql);
    $update_stmt->execute([
        ':company_id' => $company_id,
        ':product_id' => $product_id,
        ':discount_value' => $discount_value,
        ':discount_type' => $discount_type,
        ':quantity' => $quantity,
        ':id' => $id
    ]);

    header('Location: manage_discounts.php');
    exit;
}

// Fetch companies and products for the form
$companies = $pdo->query("SELECT * FROM companies")->fetchAll(PDO::FETCH_ASSOC);
$products = $pdo->query("SELECT * FROM products")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Discount</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container">
    <h1 class="mt-4">Edit Discount</h1>

    <form method="POST">
        <div class="form-group">
            <label for="company_id">Company</label>
            <select name="company_id" id="company_id" class="form-control" required>
                <?php foreach ($companies as $company): ?>
                    <option value="<?= htmlspecialchars($company['id']) ?>" <?= $company['id'] == $discount['company_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($company['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="product_id">Product</label>
            <select name="product_id" id="product_id" class="form-control" required>
                <?php foreach ($products as $product): ?>
                    <option value="<?= htmlspecialchars($product['id']) ?>" <?= $product['id'] == $discount['product_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($product['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="discount_value">Discount Value</label>
            <input type="number" name="discount_value" id="discount_value" class="form-control" value="<?= htmlspecialchars($discount['discount_value']) ?>" required>
        </div>
        <div class="form-group">
            <label for="discount_type">Discount Type</label>
            <select name="discount_type" id="discount_type" class="form-control" required>
                <option value="percentage" <?= $discount['discount_type'] == 'percentage' ? 'selected' : '' ?>>Percentage</option>
                <option value="amount" <?= $discount['discount_type'] == 'amount' ? 'selected' : '' ?>>Direct Amount</option>
            </select>
        </div>
        <div class="form-group">
            <label for="quantity">Minimum Quantity for Discount</label>
            <input type="number" name="quantity" id="quantity" class="form-control" value="<?= htmlspecialchars($discount['quantity']) ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Update Discount</button>
    </form>

    <a href="manage_discounts.php" class="btn btn-secondary mt-3">Back to Discounts</a>
</div>
</body>
</html>
