<?php
include 'db.php'; // Include your database connection
include 'header.php';

// Check if a user ID is provided in the URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "No user ID provided.";
    exit;
}

$user_id = (int)$_GET['id'];

// Fetch the user details from the database
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo "User not found.";
    exit;
}

// Handle form submission to update user details
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    // Only update password if provided
    if (!empty($password)) {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        $sql = "UPDATE users SET username = ?, email = ?, password = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$username, $email, $password_hash, $user_id]);
    } else {
        $sql = "UPDATE users SET username = ?, email = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$username, $email, $user_id]);
    }

    echo "<div class='alert alert-success'>User details updated successfully.</div>";

    // Fetch the updated user data
    $sql = "SELECT * FROM users WHERE id = ?";
    $stmt = $pdo->prepare($sql); // New statement for fetching data
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container">
    <h1 class="mt-4">Edit User</h1>

    <form method="POST">
        <div class="form-group">
            <label for="username">Username</label>
            <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" required>
        </div>

        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
        </div>

        <div class="form-group">
            <label for="password">Password (Leave blank if not changing)</label>
            <input type="password" name="password" class="form-control">
        </div>

        <button type="submit" class="btn btn-primary">Update User</button>
        <a href="manage_users.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
