<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require 'vendor/autoload.php'; // Ensure this is the only inclusion for PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Database connection
    try {
        $pdo = new PDO('mysql:host=your_host;dbname=your_db', 'your_username', 'your_password');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $email = $_POST['email'];
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user) {
            $user_id = $user['id'];
            $token = bin2hex(random_bytes(32));  // Generate a random token
            $expires_at = date("Y-m-d H:i:s", strtotime("+20 minutes"));

            // Insert token and expiration into the database
            $stmt = $pdo->prepare("INSERT INTO password_resets (user_id, token, expires_at) VALUES (?, ?, ?)");
            $stmt->execute([$user_id, $token, $expires_at]);

            // Create the password reset link
            $reset_link = "http://yourdomain.com/reset_password.php?token=" . urlencode($token);

            // Set up PHPMailer
            $mail = new PHPMailer(true);
            $mail->isSMTP();
            $mail->Host = 'smtp.your-email-provider.com'; // Your SMTP server
            $mail->SMTPAuth = true;
            $mail->Username = 'noreply@yourdomain.com'; // Your email address
            $mail->Password = 'your-email-password'; // Your email password
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('noreply@yourdomain.com', 'Your App Name');
            $mail->addAddress($email);
            $mail->Subject = 'Password Reset Request';
            $mail->Body = "Click the following link to reset your password: $reset_link\n\nThis link expires in 20 minutes.";

            if ($mail->send()) {
                echo "An email with a reset link has been sent.";
            } else {
                echo "Failed to send reset link.";
            }
        } else {
            echo "No account found with that email address.";
        }
    } catch (PDOException $e) {
        echo "Database error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Forgot Password</title>
</head>
<body>
    <h2>Forgot Password</h2>
    <form method="POST" action="forgot-password.php">
        <label for="email">Enter your email:</label>
        <input type="email" id="email" name="email" required>
        <button type="submit">Send Reset Link</button>
    </form>
</body>
</html>
