<?php
session_start();
include 'db.php';
include 'header.php';

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user details
$sqlUser = "SELECT * FROM users WHERE id = ?";
$stmtUser = $pdo->prepare($sqlUser);
$stmtUser->execute([$user_id]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo "User not found.";
    exit;
}

$company_id = $user['company_id'];

// Fetch orders for today
$sqlOrders = "SELECT o.*, p.name AS product_name FROM orders o 
              JOIN products p ON o.product_id = p.id 
              WHERE o.user_id = ? AND DATE(o.created_at) = CURDATE()";

$stmtOrders = $pdo->prepare($sqlOrders);
$stmtOrders->execute([$user_id]);
$orders = $stmtOrders->fetchAll(PDO::FETCH_ASSOC);

if (empty($orders)) {
    echo "No orders found for today.";
    exit;
}

// Generate the invoice
require_once('vendor/autoload.php');
use TCPDF;

// Create new PDF document
$pdf = new TCPDF();
$pdf->AddPage();

// Add company logo and name
$pdf->Image('path_to_logo.png', 10, 10, 20);
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 15, htmlspecialchars($user['company_name']), 0, 1, 'C'); // Dynamically add company name
$pdf->SetFont('helvetica', '', 12);
$pdf->Cell(0, 15, 'Date: ' . date('Y-m-d H:i:s'), 0, 1, 'R');

// Add order details
$pdf->SetFont('helvetica', '', 10);
$pdf->Ln(10);
$pdf->Cell(40, 10, 'Order ID', 1);
$pdf->Cell(50, 10, 'Product Name', 1);
$pdf->Cell(30, 10, 'Quantity', 1);
$pdf->Cell(30, 10, 'Total Amount (Rs)', 1);
$pdf->Ln();

$totalAmount = 0;

foreach ($orders as $order) {
    $pdf->Cell(40, 10, $order['id'], 1);
    $pdf->Cell(50, 10, htmlspecialchars($order['product_name']), 1);
    $pdf->Cell(30, 10, $order['quantity'], 1);
    $pdf->Cell(30, 10, number_format($order['total_amount'], 2), 1);
    $pdf->Ln();
    
    $totalAmount += $order['total_amount'];
}

// Add total amount
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 15, 'Total Amount: Rs. ' . number_format($totalAmount, 2), 0, 1, 'R');

// Output the PDF
$pdf->Output('invoice.pdf', 'I');
?>
