<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'db.php';

$error = ''; // Variable to hold error messages
$successMessage = ''; // Variable to hold success messages

if (isset($_GET['message'])) {
    $successMessage = htmlspecialchars($_GET['message']);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Fetch user details based on username
    $sql = "SELECT * FROM users WHERE username = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role_id'] = $user['role_id'];
        $_SESSION['company_id'] = $user['company_id'];

        // Regenerate session ID to prevent fixation
        session_regenerate_id(true);

        // Redirect based on role
        if ($user['role_id'] == 1) {
            header('Location: admin_dashboard.php');
        } elseif ($user['role_id'] == 3) {
            header('Location: client_dashboard.php');
        } else {
            $error = "Unknown user role.";
        }
        exit;
    } else {
        $error = "Invalid username or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login & Register</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="Style/css/Clogin.css"> <!-- Link to your CSS -->
    <style>
        
body {
    background-color: #0e5091 !important;
}
.container {
    margin-top: 50px;
}
.pagination {
    margin-top: 20px;
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
body {
    background-color: #f8f9fa;
    font-family: Arial, sans-serif;
}
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
.table th, .table td {
    vertical-align: middle;
}
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    position:relative;  
    width: 50%;
}
.btn-primary {
    background-color: #007bff;
    border: none;
}
.btn-primary:hover {
    background-color: #0056b3;
}
.alert {
    margin-top: 20px;
}
.pagination {
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
label {
    font-weight: bold;
    position: absolute;

}
.container h1{
    color: black;
    font-size: x-large;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;
}
.container td, th, tr, label{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
.form-group{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
        /* Particle Effect */
        body {
            background: #0e5091;
            overflow: hidden;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            position: relative;
            max-width: 400px;
            padding: 40px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            backdrop-filter: blur(15px);
            box-shadow: 0px 4px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h1 {
            color: #FFD700;
            margin-bottom: 20px;
            font-family: 'Arial', sans-serif;
            font-size: 2rem;
        }
        input {
            width: 100%;
            padding: 15px;
            margin: 10px 0;
            border: none;
            border-radius: 5px;
            background: rgba(255, 255, 255, 0.8);
            font-size: 1rem;
        }
        button {
            background-color: #FFD700;
            color: black;
            border: none;
            padding: 10px;
            border-radius: 5px;
            width: 100%;
            font-size: 1.2rem;
            cursor: pointer;
            transition: 0.4s;
        }
        button:hover {
            background-color: #FFC300;
        }
        .social-icons a {
            color: white;
            margin: 0 10px;
            font-size: 1.5rem;
        }
        .for_get {
            font-size: 0.9rem;
            color: #4deeea;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Sign In</h1>
        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-google-plus-g"></i></a>
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
        </div>

        <?php if ($successMessage): ?>
            <div class="alert alert-success"><?= $successMessage ?></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <a href="forgot-password.php" class="for_get">Forget Your Password?</a>
            <button type="submit">Sign In</button>
        </form>
    </div>

    <!-- Particle JS for animated background -->
    <script src="http://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        particlesJS.load('particles-js', 'path/to/particles.json', function() {
            console.log('particles.js loaded!');
        });
    </script>
</body>
</html>
