<?php
session_start();
include 'db.php';

// Check if the user is logged in and is an Administrator
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Handle form submission to generate an invoice
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $order_ids = isset($_POST['order_ids']) ? $_POST['order_ids'] : [];

    if (!empty($order_ids)) {
        // Redirect to the invoice generation script with selected order IDs
        header('Location: generate_invoice.php?order_ids=' . implode(',', $order_ids));
        exit;
    } else {
        echo "<div class='alert alert-danger'>No orders selected for invoice generation.</div>";
    }
}

// Fetch orders for invoice generation
$sql = "SELECT o.*, c.name AS company_name, p.name AS product_name, p.price
        FROM orders o
        JOIN companies c ON o.company_id = c.id
        JOIN products p ON o.product_id = p.id
        WHERE o.status = 'pending'"; // Modify condition as needed
$orders = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Generate Invoice</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container">
    <h1 class="mt-4">Generate Invoice</h1>

    <form method="POST">
        <table class="table">
            <thead>
                <tr>
                    <th>Select</th>
                    <th>Order ID</th>
                    <th>Company Name</th>
                    <th>Product Name</th>
                    <th>Quantity</th>
                    <th>Price (Rs)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orders as $order): ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="order_ids[]" value="<?= htmlspecialchars($order['id']) ?>">
                        </td>
                        <td><?= htmlspecialchars($order['id']) ?></td>
                        <td><?= htmlspecialchars($order['company_name']) ?></td>
                        <td><?= htmlspecialchars($order['product_name']) ?></td>
                        <td><?= htmlspecialchars($order['quantity']) ?></td>
                        <td><?= htmlspecialchars($order['price']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <button type="submit" class="btn btn-primary">Generate Invoice</button>
    </form>
</div>
</body>
</html>
