    <?php 
    session_start();
    include 'db.php';
    include 'header.php';

    // Check if the user is logged in and is an Admin
    if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
        header('Location: login.php');
        exit;
    }

    // Initialize notification message
    $notification = '';

    // Handle adding/updating products
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        try {
            if (isset($_POST['add_product'])) {
                $name = trim($_POST['name']);
                $category_id = (int)$_POST['category_id'];
                $quantity = (int)$_POST['quantity'];
                $price = (float)$_POST['price'];
                $company_id = $_SESSION['company_id'];

                // Validate inputs
                if (empty($name) || $category_id <= 0 || $quantity < 0 || $price < 0) {
                    throw new Exception("Invalid input data.");
                }

                // Check if the product already exists
                $sql = "SELECT id, quantity FROM products WHERE name = ? AND company_id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([$name, $company_id]);
                $existing_product = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($existing_product) {
                    // Update the existing product's quantity
                    $new_quantity = $existing_product['quantity'] + $quantity;
                    $product_id = $existing_product['id'];

                    $sql = "UPDATE products SET quantity = ? WHERE id = ?";
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute([$new_quantity, $product_id]);

                    $notification = "<div class='alert alert-warning'>Product '$name' already exists. Quantity updated.</div>";
                } else {
                    // Handle file upload
                    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
                        $target_dir = "uploads/";
                        $target_file = $target_dir . uniqid() . '-' . basename($_FILES['image']['name']);
                        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

                        // Validate image file type
                        $valid_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                        if (in_array($imageFileType, $valid_extensions)) {
                            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
                                // Insert product with image
                                $sql = "INSERT INTO products (name, category_id, quantity, price, company_id, image) VALUES (?, ?, ?, ?, ?, ?)";
                                $stmt = $pdo->prepare($sql);
                                $stmt->execute([$name, $category_id, $quantity, $price, $company_id, $target_file]);

                                $notification = "<div class='alert alert-success'>Product '$name' added successfully.</div>";
                            } else {
                                throw new Exception("Error uploading file.");
                            }
                        } else {
                            throw new Exception("Invalid file type. Only JPG, JPEG, PNG & GIF files are allowed.");
                        }
                    } else {
                        throw new Exception("Please upload an image.");
                    }
                }
            } 
            elseif (isset($_POST['delete_product'])) {
                $product_id = (int)$_POST['product_id'];

                // Delete the product image file
                $stmt = $pdo->prepare("SELECT image FROM products WHERE id = ?");
                $stmt->execute([$product_id]);
                $product = $stmt->fetch();
                if ($product && file_exists($product['image'])) {
                    unlink($product['image']); // Delete the file
                }

                $sql = "DELETE FROM products WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([$product_id]);
            } elseif (isset($_POST['edit_product'])) {
    $product_id = (int)$_POST['product_id'];
    $name = trim($_POST['name']);
    $category_id = (int)$_POST['category_id'];
    $quantity = (int)$_POST['quantity'];
    $price = (float)$_POST['price'];
    $box_value = (int)$_POST['box_value']; // Capture the box value

    // Validate inputs
    if (empty($name) || $category_id <= 0 || $quantity < 0 || $price < 0 || $box_value < 0) {
        throw new Exception("Invalid input data.");
    }

    // Handle file upload if a new image is provided
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $target_dir = "uploads/";
        $target_file = $target_dir . uniqid() . '-' . basename($_FILES['image']['name']);
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Validate image file type
        $valid_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        if (in_array($imageFileType, $valid_extensions)) {
            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
                // Update product with new image
                $sql = "UPDATE products SET name = ?, category_id = ?, quantity = ?, price = ?, box_value = ?, image = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([$name, $category_id, $quantity, $price, $box_value, $target_file, $product_id]);
                $notification = "<div class='alert alert-success'>Product updated successfully.</div>";
            } else {
                throw new Exception("Error uploading file.");
            }
        } else {
            throw new Exception("Invalid file type. Only JPG, JPEG, PNG & GIF files are allowed.");
        }
    } else {
        // Update product without changing the image
        $sql = "UPDATE products SET name = ?, category_id = ?, quantity = ?, price = ?, box_value = ?  WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$name, $category_id, $quantity, $price, $box_value, $product_id]);
        }
            }
        } catch (Exception $e) {
            $notification = "<div class='alert alert-success'>Product updated successfully.</div>";
    }
    }

    // Pagination logic
    $limit = 10; // Number of products per page
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $start = ($page - 1) * $limit;

    // Fetch total number of products
    $total_sql = "SELECT COUNT(*) FROM products";
    $total_stmt = $pdo->prepare($total_sql);
    $total_stmt->execute();
    $total_products = $total_stmt->fetchColumn();
    $total_pages = ceil($total_products / $limit);

    // Fetch products with pagination
    $sql = "SELECT * FROM products LIMIT $start, $limit";
    $products = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

    // Fetch the product details for editing
    $edit_product = null;
    if (isset($_GET['edit'])) {
        $edit_product_id = (int)$_GET['edit'];
        $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$edit_product_id]);
        $edit_product = $stmt->fetch(PDO::FETCH_ASSOC);
    }
    if (isset($_POST['add_product'])) {
        $name = trim($_POST['name']);
        $category_id = (int)$_POST['category_id'];
        $quantity = (int)$_POST['quantity'];
        $price = (float)$_POST['price'];
        $box_value = (int)$_POST['box_value']; // Capture the box value
        $company_id = $_SESSION['company_id'];

    
        // Validate inputs, including the new box value
        if (empty($name) || $category_id <= 0 || $quantity < 0 || $price < 0 || $box_value < 0) {
            throw new Exception("Invalid input data.");
        }
    
        // Your existing code to handle product addition or update...
    }
    
    ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Discounts</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="./Style/css/Clogin.css">
<style>
    
body {
    background-color: #0e5091 !important;
}
.container {
    margin-top: 50px;
}
.pagination {
    margin-top: 20px;
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
body {
    background-color: #f8f9fa;
    font-family: Arial, sans-serif;
}
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
.table th, .table td {
    vertical-align: middle;
}
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    position:relative;  
    width: 50%;
}
.btn-primary {
    background-color: #007bff;
    border: none;
}
.btn-primary:hover {
    background-color: #0056b3;
}
.alert {
    margin-top: 20px;
}
.pagination {
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
label {
    font-weight: bold;
    position: absolute;

}
.container h1{
    color: black;
    font-size: x-large;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;
}
.container td, th, tr, label{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
.form-group{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
lable{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
</style>
</head>
<body>
    <!-- Main Content -->
    <div class="container">
        <h1 class="mt-4">Manage Inventory</h1>
<div class="row">
    <div class="col-md-6">
        <h2 style="color:#000;">Add Product</h2>
        <form method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="name">Product Name</label>
                <input type="text" name="name" id="name" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="category_id">Category ID</label>
                <input type="number" name="category_id" id="category_id" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="quantity">Quantity</label>
                <input type="number" name="quantity" id="quantity" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="price">Price</label>
                <input type="number" name="price" id="price" class="form-control" step="0.01" required>
            </div>
            <div class="form-group">
                <label for="image">Product Image</label>
                <input type="file" name="image" id="image" class="form-control" accept="image/*" required>
            </div>
            <div class="form-group">
    <label for="box_value">Box Value</label>
    <input type="number" name="box_value" id="box_value" class="form-control" required>
</div>

            <button type="submit" name="add_product" class="btn btn-primary">Add Product</button>
        </form>
</div>
<div class="col-md-6">
        <?php if ($edit_product): ?>
        <h2 class="mt-4">Edit Product</h2>
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="product_id" value="<?= htmlspecialchars($edit_product['id']) ?>">
            <div class="form-group">
                <label for="name">Product Name</label>
                <input type="text" name="name" id="name" class="form-control" value="<?= htmlspecialchars($edit_product['name']) ?>" required>
            </div>
            <div class="form-group">
                <label for="category_id">Category ID</label>
                <input type="number" name="category_id" id="category_id" class="form-control" value="<?= htmlspecialchars($edit_product['category_id']) ?>" required>
            </div>
            <div class="form-group">
                <label for="quantity">Quantity</label>
                <input type="number" name="quantity" id="quantity" class="form-control" value="<?= htmlspecialchars($edit_product['quantity']) ?>" required>
            </div>
            <div class="form-group">
                <label for="price">Price</label>
                <input type="number" name="price" id="price" class="form-control" step="0.01" value="<?= htmlspecialchars($edit_product['price']) ?>" required>
            </div>
            <div class="form-group">
                <label for="image">Product Image</label>
                <input type="file" name="image" id="image" class="form-control" accept="image/*">
            </div>
            <div class="form-group">
    <label for="box_value">Box Value</label>
    <input type="number" name="box_value" id="box_value" class="form-control" value="<?= htmlspecialchars($edit_product['box_value']) ?>" required>
</div>

            <button type="submit" name="edit_product" class="btn btn-warning">Update Product</button>
        </form>
        <?php endif; ?>
        </div>
        <div class="col-md-12">
        <h2 class="mt-4">Products List</h2>
        <?= $notification ?>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Category ID</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Box Value</th>
                    <th>Image</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $product): ?>
                    <tr>
                        <td><?= htmlspecialchars($product['id']) ?></td>
                        <td><?= htmlspecialchars($product['name']) ?></td>
                        <td><?= htmlspecialchars($product['category_id']) ?></td>
                        <td><?= htmlspecialchars($product['quantity']) ?></td>
                        <td><?= htmlspecialchars($product['price']) ?></td>
                        <td><?= htmlspecialchars($product['box_value']) ?></td>
                        <td>
                            <?php if (!empty($product['image'])): ?>
                                <img src="<?= htmlspecialchars($product['image']) ?>" alt="Product Image" width="100">
                            <?php endif; ?>
                        </td>
                        <td>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="product_id" value="<?= htmlspecialchars($product['id']) ?>">
                                <button type="submit" name="delete_product" class="btn btn-danger">Delete</button>
                            </form>
                            <a href="?edit=<?= htmlspecialchars($product['id']) ?>" class="btn btn-info">Edit</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Pagination Links -->
        <nav aria-label="Page navigation">
            <ul class="pagination">
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
    </div>
                </div></div><div class="container"></div>
    </body>
    </html>
