<?php
include 'db.php'; // Include your database connection
include 'header.php';

// Define how many results you want per page
$results_per_page = 10;

// Find out the number of results stored in the database
$sql = "SELECT COUNT(*) AS total FROM users";
$result = $pdo->query($sql);
$row = $result->fetch(PDO::FETCH_ASSOC); // Fetch as associative array

if ($row && isset($row['total'])) {
    $total_users = $row['total']; // Access the total count safely
} else {
    $total_users = 0; // Default to 0 if the query failed or no users found
}

// Determine the number of pages needed
$number_of_pages = ceil($total_users / $results_per_page);

// Determine which page number visitor is currently on
if (!isset($_GET['page']) || $_GET['page'] < 1) {
    $current_page = 1;
} else {
    $current_page = (int)$_GET['page'];
    if ($current_page > $number_of_pages) {
        $current_page = $number_of_pages;
    }
}

// Determine the starting limit for the results on the current page
$start_from = ($current_page - 1) * $results_per_page;

// Handle delete, block, or other actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        $selected_users = $_POST['selected_users'] ?? [];

        if ($action === 'delete' && !empty($selected_users)) {
            // Delete selected users and their related company details
            $placeholders = implode(',', array_fill(0, count($selected_users), '?'));
            $sql = "DELETE u, c FROM users u 
                    LEFT JOIN companies c ON u.company_id = c.id 
                    WHERE u.id IN ($placeholders)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($selected_users);
            echo "<div class='alert alert-success'>Selected users and their companies deleted successfully.</div>";
        } elseif ($action === 'block' && !empty($selected_users)) {
            // Block selected users
            $placeholders = implode(',', array_fill(0, count($selected_users), '?'));
            $sql = "UPDATE users SET is_blocked = 1 WHERE id IN ($placeholders)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($selected_users);
            echo "<div class='alert alert-success'>Selected users blocked successfully.</div>";
        }
    }
}

// Fetch all users and their companies with pagination
$sql = "SELECT u.id, u.username, u.password, u.email, c.id AS company_id, c.name AS company_name 
        FROM users u
        LEFT JOIN companies c ON u.company_id = c.id
        LIMIT $start_from, $results_per_page";
$stmt = $pdo->query($sql);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Users</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="./Style/css/Clogin.css">
    <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container">
    <h1 class="mt-4">Manage Users</h1>

    <!-- Display the table with users -->
    <form method="POST">
        <table class="table table-bordered mt-3">
            <thead>
                <tr>
                    <th><input type="checkbox" id="select_all"></th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Company ID</th>
                    <th>Company Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><input type="checkbox" name="selected_users[]" value="<?= $user['id'] ?>"></td>
                    <td><?= htmlspecialchars($user['username'] ?? '') ?></td>
                    <td><?= htmlspecialchars($user['email'] ?? '') ?></td>
                    <td><?= htmlspecialchars($user['company_id'] ?? 'N/A') ?></td> <!-- Show 'N/A' if no company -->
                    <td><?= htmlspecialchars($user['company_name'] ?? 'N/A') ?></td> <!-- Show 'N/A' if no company -->
                    <td>
                        <a href="edit_user.php?id=<?= $user['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="block_user.php?id=<?= $user['id'] ?>" class="btn btn-secondary btn-sm">Block</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

        <div class="form-group">
            <select name="action" class="form-control" required>
                <option value="">Select Action</option>
                <option value="delete">Delete Selected Users and Companies</option>
                <option value="block">Block Selected Users</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Apply Action</button>
    </form>

    <!-- Pagination controls -->
    <nav aria-label="Page navigation">
        <ul class="pagination">
            <?php for ($page = 1; $page <= $number_of_pages; $page++): ?>
                <li class="page-item <?= ($page == $current_page) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $page ?>"><?= $page ?></a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
</div>

<script>
    // Select/Unselect all checkboxes
    document.getElementById('select_all').addEventListener('click', function (event) {
        const checkboxes = document.querySelectorAll('input[name="selected_users[]"]');
        checkboxes.forEach(checkbox => {
            checkbox.checked = event.target.checked;
        });
    });
</script>
<div class="container"></div>
</body>
</html>
