<?php
ob_start(); // Start output buffering to prevent header issues
include 'db.php';
include 'header.php';

$notification = '';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and validate inputs
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $role_id = (int) $_POST['role_id'];
    $company_id = isset($_POST['company_id']) ? (int) $_POST['company_id'] : null;
    $email = trim($_POST['email']);

    // Input validation
    if (empty($username) || strlen($username) < 3) {
        $notification = "<div class='alert alert-danger'>Username must be at least 3 characters long.</div>";
    } elseif (empty($password) || strlen($password) < 6) {
        $notification = "<div class='alert alert-danger'>Password must be at least 6 characters long.</div>";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $notification = "<div class='alert alert-danger'>Invalid email format.</div>";
    } elseif ($company_id === null) {
        $notification = "<div class='alert alert-danger'>Company ID is missing.</div>";
    } else {
        // Check if the username already exists
        $sql = "SELECT * FROM users WHERE username = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$username]);
        $existingUser = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($existingUser) {
            // Redirect to login page if the username is taken
            header('Location: login.php?message=' . urlencode('Username already taken. Please choose a different username.'));
            exit;
        } else {
            // Hash the password and insert the new user into the database
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $sql = "INSERT INTO users (username, password, role_id, company_id, email) VALUES (?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$username, $hashed_password, $role_id, $company_id, $email]);

            // Redirect to login page with a success message
            header('Location: login.php?message=' . urlencode('Registration successful. You can now log in.'));
            exit;
        }
    }
}

ob_end_flush(); // Flush output buffer to prevent errors
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Register</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .print-btn {
            margin: 20px 0;
        }
    </style>
            <link rel="stylesheet" href="./Style/css/Clogin.css">
            <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container">
    <h1 class="mt-4">Register</h1>
    <?= $notification ?> <!-- Display notifications -->
    <form method="POST">
        <div class="form-group">
            <label for="username">Username</label>
            <input type="text" name="username" id="username" class="form-control" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" name="password" id="password" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="email">Email Address</label>
            <input type="email" name="email" id="email" class="form-control" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label for="role_id">Role</label>
            <select name="role_id" id="role_id" class="form-control" required>
                <option value="1" <?= (isset($_POST['role_id']) && $_POST['role_id'] == 1) ? 'selected' : '' ?>>Administrator</option>
                <option value="2" <?= (isset($_POST['role_id']) && $_POST['role_id'] == 2) ? 'selected' : '' ?>>Admin</option>
                <option value="3" <?= (isset($_POST['role_id']) && $_POST['role_id'] == 3) ? 'selected' : '' ?>>Client</option>
            </select>
        </div>
        <div class="form-group">
            <label for="company_id">Company</label>
            <?php if (isset($_GET['company_id'])): ?>
                <input type="hidden" name="company_id" value="<?= htmlspecialchars($_GET['company_id']) ?>">
                <p>Company ID: <?= htmlspecialchars($_GET['company_id']) ?></p>
            <?php else: ?>
                <input type="number" name="company_id" id="company_id" class="form-control" value="<?= htmlspecialchars($_POST['company_id'] ?? '') ?>" required>
            <?php endif; ?>
        </div>
        <button type="submit" class="btn btn-primary">Register</button>
    </form>
</div>
<div class="container"></div>
</body>
</html>
