<?php
session_start();
ob_start(); // Start output buffering to avoid header issues
include 'db.php';
include 'header.php'; // Ensure this file does not output anything before <?php

$notification = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_name = trim($_POST['company_name']);
    $logo = $_FILES['logo'];

    // Input validation
    if (empty($company_name) || strlen($company_name) < 3) {
        $notification = "<div class='alert alert-danger'>Company name must be at least 3 characters long.</div>";
    } elseif ($logo['error'] !== UPLOAD_ERR_OK) {
        $notification = "<div class='alert alert-danger'>Error uploading logo.</div>";
    } else {
        // Validate logo file type and size
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        if (!in_array($logo['type'], $allowed_types) || $logo['size'] > 2 * 1024 * 1024) { // Limit to 2MB
            $notification = "<div class='alert alert-danger'>Logo must be a JPEG, PNG, or GIF file and less than 2MB.</div>";
        } else {
            // Check if the company already exists
            $check_sql = "SELECT id FROM companies WHERE name = ?";
            $check_stmt = $pdo->prepare($check_sql);
            $check_stmt->execute([$company_name]);
            $company = $check_stmt->fetch();

            if ($company) {
                // Company already exists, get its ID
                $company_id = $company['id'];
                $notification = "<div class='alert alert-warning'>Company already exists.</div>";
            } else {
                // Generate a unique file name for the logo
                $logo_path = 'uploads/' . uniqid() . '-' . basename($logo['name']);
                
                // Move the uploaded file to the desired location
                if (move_uploaded_file($logo['tmp_name'], $logo_path)) {
                    try {
                        // Insert new company into the database
                        $sql = "INSERT INTO companies (name, logo) VALUES (?, ?)";
                        $stmt = $pdo->prepare($sql);
                        $stmt->execute([$company_name, $logo_path]);

                        // Get the last inserted company_id
                        $company_id = $pdo->lastInsertId();
                    } catch (PDOException $e) {
                        $notification = "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
                    }
                } else {
                    $notification = "<div class='alert alert-danger'>Failed to move uploaded logo.</div>";
                }
            }

            // Redirect to user registration page with company_id
            header("Location: register.php?company_id=$company_id");
            exit; // Ensure to exit after the redirect
        }
    }
}
ob_end_flush(); // Flush output buffer
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Register Company</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="./Style/css/Clogin.css">
    <style>
        .print-btn {
            margin: 20px 0;
        }
    </style>
            <link rel="stylesheet" href="./Style/css/Clogin.css">
            <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <h1 class="mt-4">Register Company</h1>
            <?= $notification ?> <!-- Display notifications -->
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="company_name">Company Name</label>
                    <input type="text" name="company_name" id="company_name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="logo">Company Logo</label>
                    <input type="file" name="logo" id="logo" class="form-control" accept="image/*" required>
                </div>
                <button type="submit" class="btn btn-primary">Register Company</button>
            </form>
        </div>
    </div>
</div>
</div>
<div class="container"></div>
</body>
</html>
