<?php
session_start();
include 'db.php';
include 'header.php';

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Fetch user details
$sqlUser = "SELECT * FROM users WHERE id = ?";
$stmtUser = $pdo->prepare($sqlUser);
$stmtUser->execute([$_SESSION['user_id']]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo "User not found";
    exit;
}

// Fetch all companies
$sqlCompanies = "SELECT DISTINCT u.company_id, c.name FROM users u JOIN companies c ON u.company_id = c.id";
$stmtCompanies = $pdo->prepare($sqlCompanies);
$stmtCompanies->execute();
$companies = $stmtCompanies->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Search Orders</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="./Style/css/Clogin.css">
    <style>
    
    body {
        background-color: #0e5091 !important;
    }
    .container {
        margin-top: 50px;
    }
    .pagination {
        margin-top: 20px;
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }
    .container {
        margin-top: 50px;
        max-width: 800px;
        background-color: #ffffff;
        border-radius: 5px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .form-control {
        border: 1px solid #ced4da;
        border-radius: 4px;
        position:relative;  
        width: 50%;
    }
    .btn-primary {
        background-color: #007bff;
        border: none;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .pagination {
        justify-content: center;
    }
    .disabled {
        pointer-events: none;
        cursor: default;
    }
    label {
        font-weight: bold;
        position: absolute;
    
    }
    .container h1{
        color: black;
        font-size: x-large;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;
    }
    .container td, th, tr, label{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    .form-group{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
    }
    lable{
        color: black;
        font-size: small;
        font-weight: bold;
        font-family: Georgia, 'Times New Roman', Times, serif;  
        position: relative;
    }
    </style>
</head>
<body>
<div class="container mt-4">
    <h1>Search Orders</h1>
    <form method="get" action="search_orders.php">
        <div class="form-group">
            <label for="company">Company:</label>
            <select name="company" id="company" class="form-control" required>
                <option value="">Select Company</option>
                <?php foreach ($companies as $company): ?>
                    <option value="<?= $company['company_id'] ?>" <?= (isset($_GET['company']) && $_GET['company'] == $company['company_id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($company['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="start_date">Start Date:</label>
            <input type="date" name="start_date" id="start_date" class="form-control" required value="<?= htmlspecialchars($_GET['start_date'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label for="end_date">End Date:</label>
            <input type="date" name="end_date" id="end_date" class="form-control" required value="<?= htmlspecialchars($_GET['end_date'] ?? '') ?>">
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
    </form>
</div>
<div class="container"></div>
</body>
</html>
