<?php
session_start();
include 'db.php';

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $invoiceNumber = $_POST['invoice_number'];
    $status = $_POST['status'];

    // Determine if paid or not
    $paidValue = ($status === 'paid') ? 1 : 0;

    // Update the payment status based on the invoice number
    $sql = "UPDATE orders SET paid = ? WHERE invoice_number = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$paidValue, $invoiceNumber]);

    header('Location: invoice_view.php'); // Redirect to invoice view page
    exit;
}
