<?php
include 'db.php';

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'] ?? null;
    $name = $_POST['name'] ?? null;
    $category_id = $_POST['category_id'] ?? null;
    $quantity = $_POST['quantity'] ?? null;
    $price = $_POST['price'] ?? null;

    $errors = [];

    if (!$id) {
        $errors[] = "Product ID is required.";
    }
    if (!$name) {
        $errors[] = "Product name is required.";
    }
    if ($category_id === null) {
        $errors[] = "Category ID is required.";
    }
    if ($quantity === null || $quantity < 0) {
        $errors[] = "Quantity must be a positive number.";
    }
    if ($price === null || $price < 0) {
        $errors[] = "Price must be a positive number.";
    }

    if (empty($errors)) {
        $sql = "UPDATE products SET name = ?, category_id = ?, quantity = ?, price = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$name, $category_id, $quantity, $price, $id]);

        header('Location: index.php?success=Product updated successfully');
        exit;
    }
}

// Handle GET request
$id = $_GET['id'] ?? null;
if ($id) {
    $sql = "SELECT * FROM products WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$product) {
        die('Product not found.');
    }
} else {
    die('Product ID is missing.');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Product</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container">
    <h1 class="mt-4">Update Product</h1>
    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <?= implode('<br>', $errors); ?>
        </div>
    <?php endif; ?>
    <form method="POST">
        <input type="hidden" name="id" value="<?= htmlspecialchars($product['id']) ?>">
        <div class="form-group">
            <label for="name">Product Name</label>
            <input type="text" name="name" id="name" class="form-control" value="<?= htmlspecialchars($product['name'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label for="category_id">Category ID</label>
            <input type="number" name="category_id" id="category_id" class="form-control" value="<?= htmlspecialchars($product['category_id'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label for="quantity">Quantity</label>
            <input type="number" name="quantity" id="quantity" class="form-control" value="<?= htmlspecialchars($product['quantity'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label for="price">Price</label>
            <input type="number" name="price" id="price" class="form-control" step="0.01" value="<?= htmlspecialchars($product['price'] ?? '') ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Update Product</button>
    </form>
</div>
</body>
</html>
