<?php
session_start();
include 'db.php';
include 'header.php';

// Check if the user is logged in and is an Admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    header('Location: login.php');
    exit;
}

// Fetch all pending orders
$sqlPending = "SELECT o.id AS order_id, o.user_id, o.product_id, o.quantity, o.status, 
                      p.name AS product_name, p.price AS product_price, 
                      d.discount_percentage, d.discount_type, d.discount_value,
                      (CASE 
                          WHEN d.discount_type = 'percentage' THEN (p.price * o.quantity * (d.discount_percentage / 100))
                          WHEN d.discount_type = 'fixed_amount' THEN (d.discount_value * o.quantity)
                          ELSE 0
                      END) AS discount_amount,
                      (p.price * o.quantity) - 
                      (CASE 
                          WHEN d.discount_type = 'percentage' THEN (p.price * o.quantity * (d.discount_percentage / 100))
                          WHEN d.discount_type = 'fixed_amount' THEN (d.discount_value * o.quantity)
                          ELSE 0
                      END) AS total_amount,
                      c.name AS company_name,
                      o.created_at,
                      o.delivered_on_time,
                      o.delivery_date
               FROM orders o
               JOIN products p ON o.product_id = p.id
               LEFT JOIN discounts d ON p.id = d.product_id 
               AND d.company_id = (SELECT company_id FROM users WHERE id = o.user_id)
               LEFT JOIN users u ON o.user_id = u.id
               LEFT JOIN companies c ON u.company_id = c.id
               WHERE o.status = 'Pending'";

$stmtPending = $pdo->query($sqlPending);
$pendingOrders = $stmtPending->fetchAll(PDO::FETCH_ASSOC);

// Fetch all delivered orders
$sqlDelivered = "SELECT o.id AS order_id, o.user_id, o.product_id, o.quantity, o.status, 
                        p.name AS product_name, p.price AS product_price, 
                        d.discount_percentage, d.discount_type, d.discount_value,
                        (CASE 
                            WHEN d.discount_type = 'percentage' THEN (p.price * o.quantity * (d.discount_percentage / 100))
                            WHEN d.discount_type = 'fixed_amount' THEN (d.discount_value * o.quantity)
                            ELSE 0
                        END) AS discount_amount,
                        (p.price * o.quantity) - 
                        (CASE 
                            WHEN d.discount_type = 'percentage' THEN (p.price * o.quantity * (d.discount_percentage / 100))
                            WHEN d.discount_type = 'fixed_amount' THEN (d.discount_value * o.quantity)
                            ELSE 0
                        END) AS total_amount,
                        c.name AS company_name,
                        o.created_at,
                        o.delivered_on_time,
                        o.delivery_date
                 FROM orders o
                 JOIN products p ON o.product_id = p.id
                 LEFT JOIN discounts d ON p.id = d.product_id 
                 AND d.company_id = (SELECT company_id FROM users WHERE id = o.user_id)
                 LEFT JOIN users u ON o.user_id = u.id
                 LEFT JOIN companies c ON u.company_id = c.id
                 WHERE o.status = 'Delivered'";

$stmtDelivered = $pdo->query($sqlDelivered);
$deliveredOrders = $stmtDelivered->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
    
body {
    background-color: #0e5091 !important;
}
.container {
    margin-top: 50px;
}
.pagination {
    margin-top: 20px;
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
body {
    background-color: #f8f9fa;
    font-family: Arial, sans-serif;
}
.container {
    margin-top: 50px;
    max-width: 800px;
    background-color: #ffffff;
    border-radius: 5px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
.table th, .table td {
    vertical-align: middle;
}
.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    position:relative;  
    width: 50%;
}
.btn-primary {
    background-color: #007bff;
    border: none;
}
.btn-primary:hover {
    background-color: #0056b3;
}
.alert {
    margin-top: 20px;
}
.pagination {
    justify-content: center;
}
.disabled {
    pointer-events: none;
    cursor: default;
}
label {
    font-weight: bold;
    position: absolute;

}
.container h1{
    color: black;
    font-size: x-large;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;
}
.container td, th, tr, label{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
.form-group{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
}
lable{
    color: black;
    font-size: small;
    font-weight: bold;
    font-family: Georgia, 'Times New Roman', Times, serif;  
    position: relative;
}
</style>
</head>
<body>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <h1 class="mt-4">View Orders</h1>

            <h3>Pending Orders</h3>
            <table class="table">
                <thead>
                    <tr>
                        <!-- <th>Order ID</th>
                        <th>User ID</th> -->
                        <th>Product Name</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Discount Type</th>
                        <th>Discount (%) or Amount</th>
                        <th>Discount Amount</th>
                        <th>Total Amount</th>
                        <th>Company Name</th>
                        <th>Created At</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($pendingOrders)): ?>
                        <tr>
                            <td colspan="12">No pending orders found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($pendingOrders as $order): ?>
                            <tr>
                                <!-- <td><?= htmlspecialchars($order['order_id']) ?></td>
                                <td><?= htmlspecialchars($order['user_id']) ?></td> -->
                                <td><?= htmlspecialchars($order['product_name']) ?></td>
                                <td><?= htmlspecialchars($order['quantity']) ?></td>
                                <td><?= htmlspecialchars(number_format($order['product_price'], 0)) ?> Rs</td>
                                <td><?= htmlspecialchars($order['discount_type'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['discount_percentage'] ?? $order['discount_value'] ?? '0') ?> Rs</td>
                                <td><?= htmlspecialchars(number_format($order['discount_amount'] ?? 0, 0)) ?> Rs</td>
                                <td><?= htmlspecialchars(number_format($order['total_amount'], 0)) ?> Rs</td>
                                <td><?= htmlspecialchars($order['company_name'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['created_at'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['status']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <h3>Delivered Orders</h3>
            <table class="table">
                <thead>
                    <tr>
                        <!-- <th>Order ID</th>
                        <th>User ID</th> -->
                        <th>Product Name</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Discount Type</th>
                        <th>Discount (%) or Amount</th>
                        <th>Discount Amount</th>
                        <th>Total Amount</th>
                        <th>Company Name</th>
                        <th>Created At</th>
                        <th>Delivered On Time</th>
                        <th>Delivery Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($deliveredOrders)): ?>
                        <tr>
                            <td colspan="14">No delivered orders found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($deliveredOrders as $order): ?>
                            <tr>
                                <!-- <td><?= htmlspecialchars($order['order_id']) ?></td>
                                <td><?= htmlspecialchars($order['user_id']) ?></td> -->
                                <td><?= htmlspecialchars($order['product_name']) ?></td>
                                <td><?= htmlspecialchars($order['quantity']) ?></td>
                                <td><?= htmlspecialchars(number_format($order['product_price'], 0)) ?> Rs</td>
                                <td><?= htmlspecialchars($order['discount_type'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['discount_percentage'] ?? $order['discount_value'] ?? '0') ?></td>
                                <td><?= htmlspecialchars(number_format($order['discount_amount'] ?? 0, 0)) ?> Rs</td>
                                <td><?= htmlspecialchars(number_format($order['total_amount'], 0)) ?> Rs</td>
                                <td><?= htmlspecialchars($order['company_name'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['created_at'] ?? 'N/A') ?></td>
                                
                                <td><?= htmlspecialchars($order['delivery_date']? 'No': 'Yes') ?></td>
                                <td><?= htmlspecialchars($order['delivered_on_time'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['status']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="container"></div>
</body>
</html>
